﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Net;
using System.Net.Sockets;
namespace ClientForm
{
    
    public partial class Client : Form
    {
        
        
        public static bool      bReadThreadStop;
        public static bool      bSendThreadStop;
        public static bool      bCC3000ThreadTestStop;
        private IPConfig        ClientConnectionInfo ;
        private IPAddress       RemoteIPAddress;
        private IPEndPoint      RemoteEndPoint;
        private Socket          ClientC;
        private EventWaitHandle ConnectDone;
        private EventWaitHandle SendDone; 
        private EventWaitHandle ReceiveDone;
        private EventWaitHandle SendNextPacket;
    

        private string          textConnectedClient;
        private int             NumberOfBytesSent;
        private int             NumnerOfBytesRead;
        private int             SumNumberOfBytesSent;
        private int             SumNumnerOfBytesRead;
        private int             RxMsgCount;
        private int             TotalNumberofBytesRead;
        private bool            ConnectSucess;
        private byte[]          ReceiveDataBuffer;
        private int             nNumOfBytesToRead;
    

        byte                    Loop;
        
        private delegate void UpdateTextDelegate();
    

        public Client()
        {
            InitializeComponent();

            ConnectDone =   new EventWaitHandle(false, EventResetMode.AutoReset);

            SendDone    =   new EventWaitHandle(false, EventResetMode.AutoReset);

            ReceiveDone =   new EventWaitHandle(false, EventResetMode.AutoReset);

            SendNextPacket = new EventWaitHandle(false, EventResetMode.AutoReset);

            textConnectedClient = null;

            NumberOfBytesSent = 0;

            NumnerOfBytesRead = 0;

            nNumOfBytesToRead = 5000;//Initialize with max buff length, change it after doing send operation

            Loop = 0;
            
            SumNumberOfBytesSent = 0;
            
            SumNumnerOfBytesRead = 0;

            bReadThreadStop = false;

            bSendThreadStop = false;

            ConnectSucess = false;

            ReceiveDataBuffer = new byte[5000];

            TotalNumberofBytesRead = 0;

            RxMsgCount = 0;

            textConnectedServer.Text = "";

            

            bCC3000ThreadTestStop = false;

            Update();
        }

        public void SendMsgThreadProc()
        {
            try
            {
                bSendThreadStop = false;

                while (bSendThreadStop == false)
                {
                    int i = 0, j = 0;

                    byte[] byteData = new byte[Convert.ToInt32(MsgLength.Text)];
                    
                    nNumOfBytesToRead = Convert.ToInt32(MsgLength.Text);
                    
                    for (j = 0; (j < Convert.ToInt32(EditMSGCount.Text)) && (bSendThreadStop == false); j++)
                    {
                        for (i = 0; i < byteData.Length; i++)
                        {
                            byteData[i] = (byte)(i);
                        }

                        Loop++;
                        
                        ClientC.BeginSend(byteData, 0, byteData.Length, 0, new AsyncCallback(SendCallback), ClientC);

                        SendDone.WaitOne();
                       
                        if (EnableLoop.Checked)
                        {
                            SendNextPacket.WaitOne();
                        }                   
                        Thread.Sleep(Convert.ToInt32(Delay.Text));//I generally  use 10 ms of delay in between two send operation while sending a data of 100 bytes to CC3000
                    }
                    
                    bSendThreadStop = true;


                }
               
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Source + " : " + ex.Message, ex.HelpLink, MessageBoxButtons.OK, MessageBoxIcon.Error);
                
            }
            bSendThreadStop = false;

            SendMsg.BeginInvoke(new UpdateTextDelegate(EnableSemdMSgButton));

        }
        
        public void ReadMsgThreadProc()
        {
            try
            {
                while (bReadThreadStop == false)
                {
                    // Begin receiving the data from the remote device.
                    ClientC.BeginReceive(ReceiveDataBuffer, 0, nNumOfBytesToRead, 0, new AsyncCallback(ReceiveCallback), ClientC);
                                      
                    ReceiveDone.WaitOne();
                  
                    SendNextPacket.Set();
                    
                                     
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Source + " : " + ex.Message, ex.HelpLink, MessageBoxButtons.OK, MessageBoxIcon.Error);

                bSendThreadStop = true;

                bReadThreadStop = true;

                ConnectToServer.Enabled = true;
            }
            RxMsgCount = 0;
            
        }
       
        private void ConnectToServer_Click(object sender, EventArgs e)
        {
            
            try
            {
                ClientConnectionInfo = new IPConfig();

                ClientConnectionInfo.ShowDialog();

                ClientConnectionInfo.ConnectEvent.WaitOne();

                
                RemoteIPAddress = IPAddress.Parse(ClientConnectionInfo.RemoteIPaddress);

                RemoteEndPoint = new IPEndPoint(RemoteIPAddress, Convert.ToInt32(ClientConnectionInfo.RemotePortNumber));

                ClientC = new Socket(AddressFamily.InterNetwork,SocketType.Stream, ProtocolType.Tcp);
                
                ClientC.BeginConnect(RemoteEndPoint, new AsyncCallback(ConnectCallback), ClientC);
                
                ConnectDone.WaitOne();

                if (ConnectSucess == true)
                {
                    bReadThreadStop = false;

                    bSendThreadStop = false;

                    bCC3000ThreadTestStop = false;

                    ConnectToServer.Enabled = false;

                    Thread ReadMsgThread = new Thread(new ThreadStart(ReadMsgThreadProc));
                   
                    ReadMsgThread.Start();
               }
            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Source+" : "+ex.Message, ex.HelpLink, MessageBoxButtons.OK, MessageBoxIcon.Error);
                
                bSendThreadStop = true;

                bReadThreadStop = true;

                bCC3000ThreadTestStop = true;

                ConnectToServer.Enabled = true;
            }
        }
        
        private void ReceiveCallback(IAsyncResult ar)
        {
            try
            {
                Socket client = (Socket)ar.AsyncState;

                // Read data from the remote device.
                NumnerOfBytesRead = client.EndReceive(ar);

                TotalNumberofBytesRead += NumnerOfBytesRead;

                SumNumnerOfBytesRead += NumnerOfBytesRead;

                RxMsgCount++;

                if (RxEnable.Checked == true)
                {
                    RxMSGBox.BeginInvoke(new UpdateTextDelegate(UpdateReadMsgText));
                }
                else
                {
                    ReceiveDone.Set();
                }
                
                
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Source + " : " + ex.Message, ex.HelpLink, MessageBoxButtons.OK, MessageBoxIcon.Error);

                bSendThreadStop = true;

                bReadThreadStop = true;

                bCC3000ThreadTestStop = true;

                ConnectToServer.Enabled = true;

                ReceiveDone.Set();

                
            }
        }
        
        private void ConnectCallback(IAsyncResult ar)
        {
            try
            {
                
                ClientC = (Socket)ar.AsyncState;

                ClientC.EndConnect(ar);
                
                textConnectedClient = "Socket connected to " + ClientC.RemoteEndPoint.ToString();

               ConnecetedClient.BeginInvoke(new UpdateTextDelegate(UpdateClientConnectedText));

               ConnectSucess = true;
                
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Source + " : " + ex.Message, ex.HelpLink, MessageBoxButtons.OK, MessageBoxIcon.Error);

                ConnectSucess = false;
            }

            // Signal that the connection has been made.
            ConnectDone.Set();
        }

        private void SendMsg_Click(object sender, EventArgs e)
        {
            try
            {
                SendMsg.Enabled = false;

                Thread SendMsgThread = new Thread(new ThreadStart(SendMsgThreadProc));

                SendMsgThread.Start();
                 
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Source + " : " + ex.Message, ex.HelpLink, MessageBoxButtons.OK, MessageBoxIcon.Error);

                bSendThreadStop = true;

                SendMsg.Enabled = true;
            }
        }
      
        private void SendCallback(IAsyncResult ar)
        {
            try
            {
                int BytesSent = 0;
                               
                Socket client = (Socket)ar.AsyncState;
                              
                BytesSent = client.EndSend(ar);
                
                NumberOfBytesSent += BytesSent;
                
                SumNumberOfBytesSent += BytesSent;

                
                
            }
            catch (Exception ex)
            {
                bSendThreadStop = true;

                bReadThreadStop = true;

                bCC3000ThreadTestStop = true;

                MessageBox.Show(ex.Source + " : " + ex.Message, ex.HelpLink, MessageBoxButtons.OK, MessageBoxIcon.Error);
               
            }
            SendDone.Set();
        }
                
        private void UpdateSendMSgRateText()
        {
            SendMsgRate.Text = NumberOfBytesSent.ToString();

            TotalSend.Text = SumNumberOfBytesSent.ToString();

            NumberOfBytesSent = 0;
        }
       
        private void UpdateClientConnectedText()
        {
            textConnectedServer.Text = textConnectedClient;
            
            textConnectedClient = null;
        }

        private void UpdateReadMSgRateText()
        {
            ReadMsgRate.Text = TotalNumberofBytesRead.ToString();

            TotalRead.Text = SumNumnerOfBytesRead.ToString();

            TotalNumberofBytesRead = 0;
        }

        private void EnableSemdMSgButton()
        {
            SendMsg.Enabled = true;
        }

        private void UpdateReadMsgText()
        {
            
            string S = "";

            S = "Msg Count : " + RxMsgCount.ToString() + " ; " + "Msg Length : " + NumnerOfBytesRead.ToString();
                       
            RxMSGBox.Text += (S + Environment.NewLine);
            
            Application.DoEvents();

            Update();
            
            NumnerOfBytesRead = 0;
            RxMSGBox.SelectionStart = RxMSGBox.Text.Length;
            RxMSGBox.ScrollToCaret();
            ReceiveDone.Set();
        }

        private void Timer_1Sec_Tick(object sender, EventArgs e)
        {
           
            SendMsgRate.BeginInvoke(new UpdateTextDelegate(UpdateSendMSgRateText));
            
            ReadMsgRate.BeginInvoke(new UpdateTextDelegate(UpdateReadMSgRateText));
            
         }

        private void DisconnectFromServer_Click(object sender, EventArgs e)
        {
           
            bReadThreadStop = true;

            bSendThreadStop = true;

            bCC3000ThreadTestStop = true;

            ConnectToServer.Enabled = true;

            ReceiveDone.Set();

            SendDone.Set();

            try
            {
               // ClientC.Shutdown(SocketShutdown.Both);

                //ClientC.Close();
            }
            catch 
            {
               
                //MessageBox.Show(ex.Source + " : " + ex.Message, ex.HelpLink, MessageBoxButtons.OK, MessageBoxIcon.Error);

            }
          
        }

        private void RxEnable_CheckedChanged(object sender, EventArgs e)
        {
            /*
            if (RxEnable.Checked)
            {
                RxEnable.Checked = false;
                displayMsg = false;
            }
            else
            {
                RxEnable.Enabled = true;
                displayMsg = true;
            }
            */
        }

   }
}
